/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.feet;

import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.HurtSoundModifyingItem;
import artifacts.common.util.DamageSourceHelper;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class KittySlippersItem
extends HurtSoundModifyingItem {
    public KittySlippersItem() {
        super(SoundEvents.f_11791_);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
        this.addListener(LivingSetAttackTargetEvent.class, this::onLivingSetAttackTarget, LivingSetAttackTargetEvent::getTarget);
        this.addListener(LivingEvent.LivingUpdateEvent.class, this::onLivingUpdate, (T event) -> event.getEntityLiving().m_142581_());
        this.addListener(LivingAttackEvent.class, this::onLivingAttack, (T event) -> DamageSourceHelper.getAttacker(event.getSource()));
    }

    private void onLivingAttack(LivingAttackEvent event, LivingEntity wearer) {
        if (event.getEntityLiving() instanceof Creeper) {
            this.damageEquippedStacks(wearer);
        }
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity2;
        if (!ModConfig.server.isCosmetic(this) && (entity2 = event.getEntity()) instanceof Creeper) {
            Creeper creeper = (Creeper)entity2;
            creeper.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)creeper, Player.class, entity -> entity != null && this.isEquippedBy((LivingEntity)entity), 6.0f, 1.0, 1.3, EntitySelector.f_20406_::test));
        }
    }

    private void onLivingSetAttackTarget(LivingSetAttackTargetEvent event, LivingEntity wearer) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Creeper) {
            Creeper creeper = (Creeper)livingEntity;
            creeper.m_6710_(null);
        }
    }

    private void onLivingUpdate(LivingEvent.LivingUpdateEvent event, LivingEntity wearer) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Creeper) {
            Creeper creeper = (Creeper)livingEntity;
            creeper.m_6703_(null);
        }
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11785_, 1.0f, 1.0f);
    }
}

